IF OBJECT_ID('P_EXP_CTB_MOV_TRANSF_LOJA_MATRIZ') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_TRANSF_LOJA_MATRIZ
	END
 
GO
  
 
CREATE PROCEDURE P_EXP_CTB_MOV_TRANSF_LOJA_MATRIZ( @CD_EMP		INT,
												   @CD_FILIAL	INT,
												   @DT_INI		DATETIME,
												   @DT_FIM		DATETIME,
												   @FLAG_LIMPAR INT = 0)		
	
WITH ENCRYPTION AS  
SET NOCOUNT ON; 

BEGIN
	
	DECLARE @RS_CD_EMP				INT
	DECLARE @RS_CD_FILIAL			INT 		
	DECLARE @RS_DT_MOV				DATETIME					
	DECLARE @RS_VLR_DINHEIRO			MONEY
	DECLARE @RS_VLR_CHQ_VISTA		MONEY	
	DECLARE @NR_CONTROLE			VARCHAR (12)

	------------------------------------------------------------------------------------------------------------------------------
	--CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------
	EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV @FLAG_LIMPAR
	
	
	DECLARE RS_RESULT
	CURSOR FOR 	
		SELECT
			@CD_EMP AS CD_EMP,
			CD_FILIAL,
			DT_MOV,
			SUM(VLR_DINHEIRO) - SUM(VLR_RECBTO_CREDIARIO)	AS VLR_DINHEIRO,
			SUM(VLR_CHQ_VISTA)	AS VLR_CHQ_VISTA
		FROM UFD_EXP_CTB_MOV_CAIXA(@CD_EMP, @CD_FILIAL, @DT_INI, @DT_FIM)
		--FROM UFD_EXP_CTB_MOV_CAIXA(1, 2, '20170201', '20170201')
		GROUP BY 
			CD_FILIAL,
			DT_MOV
		ORDER BY 			
			CD_FILIAL,
			DT_MOV
		

		--Abrindo cursor
		OPEN RS_RESULT
		
		--Atribuindo valores do select nas variáveis
		FETCH NEXT FROM RS_RESULT INTO 
					@RS_CD_EMP,
					@RS_CD_FILIAL,
					@RS_DT_MOV,
					@RS_VLR_DINHEIRO,
					@RS_VLR_CHQ_VISTA	
					 

		--Iniciando laço
		WHILE @@FETCH_STATUS = 0
			BEGIN	
						   						
				SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
					RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
						RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
						RIGHT('000'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),3)	+  '112'  -- 11 CD_MOVIMENTO 01 tipo de registro 
			
				IF @RS_VLR_DINHEIRO > 0 				
					BEGIN             
						  ------------------------------------------------------------------------------------------------------------------
						  --DOACAO DEBITO - Ctb_Cnt_Caixa
						  ------------------------------------------------------------------------------------------------------------------
						  
						  --===== Tipos de Registros de movimento de vendas para código de Controle usado no  Número de Documento ===================
						  --1 - dinheiro						  
						  --2 - cheque
						
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
								RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
								 RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
								  RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2)	+  '111'  -- 11 CD_MOVIMENTO 01 tipo de registro 

						  --===========================================================================================================================	
						  

						INSERT INTO ##CTB_EXP_MOV 
						
							 (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)
 
							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										11												AS CD_MOVIMENTO,
										'TRANSFERENCIA DE DINHEIRO DA LOJA P/ MATRIZ'	AS MOVIMENTO,
										''												AS OPERACAO,
										'TRANSFERENCIA DINHEIRO - DEBITO'				AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''												AS CD_CNT_CREDITO,
										0												AS CD_CNT_RED_DEBITO,
										''												AS CD_CNT_DEBITO,
										@RS_DT_MOV						AS DT_MOV,
										'VALOR REF. RECEBIMENTO DAS VENDAS DO DIA ' + CONVERT(VARCHAR(10), @RS_DT_MOV, 101) + ' (DINHEIRO)' AS HIST,								
										@RS_VLR_DINHEIRO								AS VLR_LANC,
										'D'												AS TP_TRANSA,
										0												AS RATEIO_CENTRO_CUSTO,
										''												AS DS_CENTRO_CUSTO,
										0												AS CNT_CENTRO_CUSTO,
										0												AS VLR_CENTRO_CUSTO,
										'MATRIZ'										AS ORIG_CONTA,
										14												AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE	
										  , 'T' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , 0  AS NR_DP
										  , 0  AS ANO
										  , @NR_CONTROLE AS NR_DOC
										  , 0 AS CD_BC_LANC;
										
						------------------------------------------------------------------------------------------------------------------
						--DOACAO DEBITO - Ctb_Cnt_Caixa
						------------------------------------------------------------------------------------------------------------------
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										11												AS CD_MOVIMENTO,
										'TRANSFERENCIA DE DINHEIRO DA LOJA P/ MATRIZ'	AS MOVIMENTO,
										'TRANSFERENCIA DINHEIRO - CREDITO'				AS OPERACAO,
										''												AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''												AS CD_CNT_CREDITO,
										0												AS CD_CNT_RED_DEBITO,
										''												AS CD_CNT_DEBITO,
										@RS_DT_MOV						AS DT_MOV,
										'VALOR REF. RECEBIMENTO DAS VENDAS DO DIA ' + CONVERT(VARCHAR(10), @RS_DT_MOV, 101) + ' (DINHEIRO)' AS HIST,								
										@RS_VLR_DINHEIRO								AS VLR_LANC,
										'C'												AS TP_TRANSA,
										0												AS RATEIO_CENTRO_CUSTO,
										''												AS DS_CENTRO_CUSTO,
										0												AS CNT_CENTRO_CUSTO,
										0												AS VLR_CENTRO_CUSTO,
										'FILIAIS'										AS ORIG_CONTA,
										14												AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE	
										  , 'T' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , 0  AS NR_DP
										  , 0  AS ANO
										  , @NR_CONTROLE AS NR_DOC
										  , 0 AS CD_BC_LANC;
					END


				IF @RS_VLR_CHQ_VISTA > 0 				
					
					BEGIN             
						------------------------------------------------------------------------------------------------------------------
						--DOACAO DEBITO - Ctb_Cnt_Caixa
						------------------------------------------------------------------------------------------------------------------

						--===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Número de Documento ===================
						  --1 - dinheiro						  
						  --2 - cheque


						  --===========================================================================================================================	


						INSERT INTO ##CTB_EXP_MOV  

							 (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										11												AS CD_MOVIMENTO,
										'TRANSFERENCIA DE CHEQUES DA LOJA P/ MATRIZ'	AS MOVIMENTO,
										''												AS OPERACAO,
										'TRANSFERENCIA CHEQUES - DEBITO'				AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''												AS CD_CNT_CREDITO,
										0												AS CD_CNT_RED_DEBITO,
										''												AS CD_CNT_DEBITO,
										@RS_DT_MOV						AS DT_MOV,
										'VALOR REF. RECEBIMENTO DAS VENDAS DO DIA ' + CONVERT(VARCHAR(10), @RS_DT_MOV, 101) + ' (CHEQUE A VISTA)' AS HIST,								
										@RS_VLR_CHQ_VISTA								AS VLR_LANC,
										'D'												AS TP_TRANSA,
										0												AS RATEIO_CENTRO_CUSTO,
										''												AS DS_CENTRO_CUSTO,
										0												AS CNT_CENTRO_CUSTO,
										0												AS VLR_CENTRO_CUSTO,
										'MATRIZ'										AS ORIG_CONTA,
										14												AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE	
										 , 'T' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , 0  AS NR_DP
										  , 0  AS ANO
										  , @NR_CONTROLE AS NR_DOC
										  , 0 AS CD_BC_LANC;
										
						------------------------------------------------------------------------------------------------------------------
						--DOACAO DEBITO - Ctb_Cnt_Caixa
						------------------------------------------------------------------------------------------------------------------
						INSERT INTO ##CTB_EXP_MOV 
						
							(CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

						 
							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										11												AS CD_MOVIMENTO,
										'TRANSFERENCIA DE CHEQUES DA LOJA P/ MATRIZ'	AS MOVIMENTO,
										'TRANSFERENCIA CHEQUES - CREDITO'				AS OPERACAO,
										''												AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''												AS CD_CNT_CREDITO,
										0												AS CD_CNT_RED_DEBITO,
										''												AS CD_CNT_DEBITO,
										@RS_DT_MOV						AS DT_MOV,
										'VALOR REF. RECEBIMENTO DAS VENDAS DO DIA ' + CONVERT(VARCHAR(10), @RS_DT_MOV, 101) + ' (CHEQUE A VISTA)' AS HIST,								
										@RS_VLR_CHQ_VISTA								AS VLR_LANC,
										'C'												AS TP_TRANSA,
										0												AS RATEIO_CENTRO_CUSTO,
										''												AS DS_CENTRO_CUSTO,
										0												AS CNT_CENTRO_CUSTO,
										0												AS VLR_CENTRO_CUSTO,
										'FILIAIS'										AS ORIG_CONTA,
										14												AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE	
									    , 'T' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , 0  AS NR_DP
										  , 0  AS ANO
										  , @NR_CONTROLE AS NR_DOC
										  , 0 AS CD_BC_LANC;
					END
					
		
				------------------------------------------------------------------------------------------------------------------
				--Próximo registro				
				------------------------------------------------------------------------------------------------------------------
				FETCH NEXT FROM RS_RESULT INTO 
						@RS_CD_EMP,
						@RS_CD_FILIAL,
						@RS_DT_MOV,
						@RS_VLR_DINHEIRO,
						@RS_VLR_CHQ_VISTA																

			END
		
		CLOSE RS_RESULT
		DEALLOCATE RS_RESULT	
END

 